import wave, struct, math

def generate_tone(filename, freq, duration_ms, volume=0.5):
    sample_rate = 44100
    num_samples = int(sample_rate * duration_ms / 1000)
    wav_file = wave.open(filename, 'w')
    wav_file.setparams((1, 2, sample_rate, num_samples, 'NONE', 'not compressed'))

    for i in range(num_samples):
        value = int(volume * 32767.0 * math.sin(2 * math.pi * freq * (i / sample_rate)))
        wav_file.writeframes(struct.pack('<h', value))

    wav_file.close()

# Create two test sounds
generate_tone("audio/left.wav", 440, 200)   # A4 tone
generate_tone("audio/right.wav", 660, 200)  # E5 tone
