import pygame

# Initialize Pygame
pygame.init()
pygame.mixer.init()

# Set up the display
screen_width = 800
screen_height = 600
screen = pygame.display.set_mode((screen_width, screen_height))
pygame.display.set_caption("Rocket Fire")

player1 = pygame.image.load("images/rocket.png")
player1_rect = player1.get_rect()

fire_sound = pygame.mixer.Sound("audio/laser.mp3")

# Main game loop
running = True
while running:
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False
        if event.type == pygame.KEYDOWN:
            if event.key == pygame.K_SPACE: 
                fire_sound.play()

    # Set rocket position
    player1_rect.topleft = (100, 150)

    # Draw the image to the screen
    screen.blit(player1, player1_rect)

    # Update the display with the newly drawn frame
    pygame.display.flip()

# Quit Pygame
pygame.quit()