import pygame

# --- Initialize Pygame and mixer ---
pygame.init()
pygame.mixer.init()

# --- Window setup ---
WIDTH, HEIGHT = 800, 600
screen = pygame.display.set_mode((WIDTH, HEIGHT))
pygame.display.set_caption("Reaction Sounds Game - Solution")

# --- Load player sprite and position it ---
player_image = pygame.image.load("images/rocket.png").convert_alpha()
player_rect = player_image.get_rect()
player_rect.center = (400, 300)

# --- Load audio assets ---
sfx_left = pygame.mixer.Sound("audio/left.wav")
sfx_right = pygame.mixer.Sound("audio/right.wav")
sfx_space = pygame.mixer.Sound("audio/explosion.mp3")

pygame.mixer.music.load("audio/music.mp3")
pygame.mixer.music.set_volume(0.5)
pygame.mixer.music.play(-1)  # loop continuously

# --- Main loop ---
running = True
while running:
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False

        # Move and play sounds on key press
        if event.type == pygame.KEYDOWN:
            if event.key == pygame.K_LEFT:
                player_rect.x -= 20
                sfx_left.play()
            elif event.key == pygame.K_RIGHT:
                player_rect.x += 20
                sfx_right.play()
            # Extra challenge: space action sound/message
            elif event.key == pygame.K_SPACE:
                 sfx_space.play()

    # --- Draw frame ---
    screen.fill((0, 0, 0))
    screen.blit(player_image, player_rect)
    pygame.display.flip()

# --- Clean exit ---
pygame.mixer.music.stop()
pygame.quit()
