import pygame

# Initialize Pygame
pygame.init()

# Create the game window
screen = pygame.display.set_mode((800, 600))
pygame.display.set_caption("Animated Sprite Window")

# Set up a clock to control the frame rate
clock = pygame.time.Clock()

# Load the player image frames
image_sprite = [
    pygame.image.load("images/frame01.png").convert_alpha(),
    pygame.image.load("images/frame02.png").convert_alpha(),
    pygame.image.load("images/frame03.png").convert_alpha(),
    pygame.image.load("images/frame04.png").convert_alpha()
]

# Set up player position and movement speed
player_rect = image_sprite[0].get_rect()
player_rect.topleft = (100, 300)
player_speed = 5

# Animation state
frame_index = 0
animation_timer = 0
animation_speed = 150  # milliseconds between frames

# Game loop control variable
running = True

while running:
    # Measure time since last frame and cap FPS
    frame_time = clock.tick(60)

    # Handle input events
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False

    # Update animation timer
    animation_timer += frame_time
    if animation_timer >= animation_speed:
        animation_timer %= animation_speed
        frame_index = (frame_index + 1) % len(image_sprite)


    # Fill screen with background color
    screen.fill((30, 30, 30))

    # Draw the current frame of the animated sprite
    screen.blit(image_sprite[frame_index], player_rect)

    # Update the display
    pygame.display.flip()

pygame.quit()
