import pygame

# Initialize Pygame
pygame.init()

# Create the game window
screen = pygame.display.set_mode((800, 600))
pygame.display.set_caption("Simple Sprite Animation")

# Set up a clock to control frame rate
clock = pygame.time.Clock()

# Load animation frames
image_sprite = [
    pygame.image.load("images/frame01.png").convert_alpha(),
    pygame.image.load("images/frame02.png").convert_alpha(),
    pygame.image.load("images/frame03.png").convert_alpha(),
    pygame.image.load("images/frame04.png").convert_alpha()
]

# Animation variables
frame_index = 0                   # Current frame in animation
animation_timer = 0               # Time accumulator
animation_speed = 150             # Time between frames in milliseconds

# Main game loop
running = True
while running:
    # Calculate time since last frame (limits to 60 FPS)
    frame_time = clock.tick(60)
    animation_timer += frame_time

    # Check for quit event
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False

    # Update animation frame if enough time has passed
    if animation_timer >= animation_speed:
        animation_timer %= animation_speed
        frame_index = (frame_index + 1) % len(image_sprite)

    # Clear the screen
    screen.fill((30, 30, 30))  # Dark gray background

    # Draw the current frame at the top-left corner
    screen.blit(image_sprite[frame_index], (0, 0))

    # Update the display
    pygame.display.flip()

# Quit Pygame
pygame.quit()
