import pygame
import random

pygame.init()

# Screen setup
WIDTH, HEIGHT = 800, 600
screen = pygame.display.set_mode((WIDTH, HEIGHT))
pygame.display.set_caption("Player vs Enemy")

clock = pygame.time.Clock()

# Load images
player_image = pygame.image.load("images/p1.png").convert_alpha()
enemy_image = pygame.image.load("images/e1.png").convert_alpha()

# Player setup
player_rect = player_image.get_rect()
player_rect.midleft = (50, HEIGHT // 2)
player_speed = 5

# Enemy setup
enemy_rect = enemy_image.get_rect()
enemy_rect.midright = (WIDTH - 50, HEIGHT // 2)
enemy_speed = 3
enemy_direction = 1  # 1 = down, -1 = up

# Bullets
player_bullet_image = pygame.Surface((12, 4))
player_bullet_image.fill((0, 255, 0))
player_bullets = []

enemy_bullet_image = pygame.Surface((12, 4))
enemy_bullet_image.fill((255, 0, 0))
enemy_bullets = []

bullet_speed = 7
enemy_fire_delay = 60
enemy_fire_timer = 0

# Main game loop
running = True
while running:
    screen.fill((10, 10, 30))

    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False

    # Input
    keys = pygame.key.get_pressed()
    if keys[pygame.K_UP] and player_rect.top > 0:
        player_rect.y -= player_speed
    if keys[pygame.K_DOWN] and player_rect.bottom < HEIGHT:
        player_rect.y += player_speed
    if keys[pygame.K_SPACE]:
        if len(player_bullets) < 5:
            bullet_rect = player_bullet_image.get_rect()
            bullet_rect.midleft = player_rect.midright
            player_bullets.append(bullet_rect)

    # Enemy AI movement
    enemy_rect.y += enemy_speed * enemy_direction
    if enemy_rect.top <= 0 or enemy_rect.bottom >= HEIGHT:
        enemy_direction *= -1

    # Enemy shooting
    enemy_fire_timer += 1
    if enemy_fire_timer >= enemy_fire_delay:
        bullet_rect = enemy_bullet_image.get_rect()
        bullet_rect.midright = enemy_rect.midleft
        enemy_bullets.append(bullet_rect)
        enemy_fire_timer = 0

    # Move bullets
    for bullet in player_bullets[:]:
        bullet.x += bullet_speed
        if bullet.left > WIDTH:
            player_bullets.remove(bullet)
        elif bullet.colliderect(enemy_rect):
            print("Enemy hit!")
            player_bullets.remove(bullet)

    for bullet in enemy_bullets[:]:
        bullet.x -= bullet_speed
        if bullet.right < 0:
            enemy_bullets.remove(bullet)
        elif bullet.colliderect(player_rect):
            print("Player hit!")
            enemy_bullets.remove(bullet)

    # Draw everything
    screen.blit(player_image, player_rect)
    screen.blit(enemy_image, enemy_rect)

    for bullet in player_bullets:
        screen.blit(player_bullet_image, bullet)
    for bullet in enemy_bullets:
        screen.blit(enemy_bullet_image, bullet)

    pygame.display.flip()
    clock.tick(60)

pygame.quit()
