import pygame
pygame.init()

screen_width = 800
screen_height = 600
screen = pygame.display.set_mode((screen_width, screen_height))
pygame.display.set_caption("Player and Enemy Demo")

player_image = pygame.image.load("images/p1.png").convert_alpha()
enemy_image = pygame.image.load("images/e1.png").convert_alpha()

player_rect = player_image.get_rect()
enemy_rect = enemy_image.get_rect()

player_rect.topleft = (100, 300)
enemy_rect.topleft = (500, 300)

running = True
while running:
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False

    screen.fill((0, 0, 0))
    screen.blit(player_image, player_rect)
    screen.blit(enemy_image, enemy_rect)
    pygame.display.flip()

pygame.quit()
