import pygame

# Initialize Pygame
pygame.init()

# Create the game window
screen = pygame.display.set_mode((800, 600))
pygame.display.set_caption("Interactive Window")

# Set up a clock to control the frame rate
clock = pygame.time.Clock()

# Load the player image
player_image = pygame.image.load("images/p1.png").convert_alpha()
player_rect = player_image.get_rect()
player_rect.topleft = (400, 300)
player_speed = 5

# Game loop control variable
running = True

while running:
    # Handle input events
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False
        elif event.type == pygame.KEYDOWN:
            if event.key == pygame.K_SPACE:
                print("Space bar pressed")
            if event.key == pygame.K_ESCAPE:
                print("Escape key pressed")

    # Get keys currently held down
    keys = pygame.key.get_pressed()
    if keys[pygame.K_LEFT]:
        player_rect.x -= player_speed
    if keys[pygame.K_RIGHT]:
        player_rect.x += player_speed
    if keys[pygame.K_UP]:
        player_rect.y -= player_speed
    if keys[pygame.K_DOWN]:
        player_rect.y += player_speed

    # Fill screen with a background color
    screen.fill((30, 30, 30))

    # Draw the player image
    screen.blit(player_image, player_rect)

    # Update the display
    pygame.display.flip()

    # Limit to 60 frames per second
    clock.tick(60)

pygame.quit()
