import pygame
pygame.init()

BLACK = pygame.Color('black')
WHITE = pygame.Color('white')
RED = pygame.Color('red')


screen = pygame.display.set_mode((700, 700))
pygame.display.set_caption("Controller Test")


clock = pygame.time.Clock()

font = pygame.font.Font(None, 30)
line_height = 25

x = 10
y = 10

running = True
while running:
    axis_movement = {}
    screen.fill(WHITE)
    x = 10
    y = 10
    
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False
        elif event.type == pygame.JOYAXISMOTION:
            axis_movement[event.axis] = True

    joystick_count = pygame.joystick.get_count()
    
    textBitmap = font.render("Number of joysticks: {}".format(joystick_count), True, BLACK)
    screen.blit(textBitmap, (x, y))
    y += line_height
    x += 10

    for i in range(joystick_count):
        joystick = pygame.joystick.Joystick(i)
        joystick.init()

        try:
            jid = joystick.get_instance_id()
        except AttributeError:
            jid = joystick.get_id()
        
        textBitmap = font.render("Joystick {}".format(jid), True, BLACK)
        screen.blit(textBitmap, (x, y))
        y += line_height
        x += 10

        name = joystick.get_name()
        textBitmap = font.render("Joystick name: {}".format(name), True, BLACK)
        screen.blit(textBitmap, (x, y))
        y += line_height

        try:
            guid = joystick.get_guid()
        except AttributeError:
            pass
        else:
            textBitmap = font.render("GUID: {}".format(guid), True, BLACK)
            screen.blit(textBitmap, (x, y))
            y += line_height

        axes = joystick.get_numaxes()
        textBitmap = font.render("Number of axes: {}".format(axes), True, BLACK)
        screen.blit(textBitmap, (x, y))
        y += line_height
        x += 10

        for i in range(axes):
            axis = joystick.get_axis(i)
            color = RED if i in axis_movement else BLACK
            textBitmap = font.render("Axis {} value: {:>6.3f}".format(i, axis), True, color)
            screen.blit(textBitmap, (x, y))
            y += line_height
        x -= 10

        buttons = joystick.get_numbuttons()
        textBitmap = font.render("Number of buttons: {}".format(buttons), True, BLACK)
        screen.blit(textBitmap, (x, y))
        y += line_height
        x += 10

        for i in range(buttons):
            button = joystick.get_button(i)
            color = RED if button else BLACK
            textBitmap = font.render("Button {:>2} value: {}".format(i, button), True, color)
            screen.blit(textBitmap, (x, y))
            y += line_height
        x -= 10

        hats = joystick.get_numhats()
        textBitmap = font.render("Number of hats: {}".format(hats), True, BLACK)
        screen.blit(textBitmap, (x, y))
        y += line_height
        x += 10

        for i in range(hats):
            hat = joystick.get_hat(i)
            color = RED if hat != (0, 0) else BLACK
            textBitmap = font.render("Hat {} value: {}".format(i, str(hat)), True, color)
            screen.blit(textBitmap, (x, y))
            y += line_height
        x -= 10

        x -= 10

    pygame.display.flip()
    clock.tick(20)

pygame.quit()
