import pygame
import sys

# Initialize Pygame and joystick module
pygame.init()
pygame.joystick.init()

# Check for connected joysticks/controllers
if pygame.joystick.get_count() == 0:
    print("No controller detected.")
    sys.exit()

# Connect to the first controller
joystick = pygame.joystick.Joystick(0)
joystick.init()
print(f"Using controller: {joystick.get_name()}")

# Create game window
screen = pygame.display.set_mode((800, 600))
pygame.display.set_caption("Controller Example")

# Set up clock to control frame rate
clock = pygame.time.Clock()

# Load player image
player_image = pygame.image.load("images/p1.png").convert_alpha()
player_rect = player_image.get_rect()
player_rect.topleft = (400, 300)
player_speed = 5

# Game loop control
running = True
while running:
    # Handle input events
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False

        elif event.type == pygame.JOYBUTTONDOWN:
            if event.button == 0:  # Example: Button 0 (A or X) pressed
                print("Button 0 pressed")
            elif event.button == 1:  # Button 1 (B or Circle)
                print("Button 1 pressed")

    # Get analog stick input or D-pad
    # Left stick X-axis (axis 0), Y-axis (axis 1)
    x_axis = joystick.get_axis(0)
    y_axis = joystick.get_axis(1)

    # Apply analog movement (deadzone for float jitter)
    if abs(x_axis) > 0.1:
        player_rect.x += int(x_axis * player_speed)
    if abs(y_axis) > 0.1:
        player_rect.y += int(y_axis * player_speed)

    # Draw frame
    screen.fill((30, 30, 30))
    screen.blit(player_image, player_rect)
    pygame.display.flip()
    clock.tick(60)

# Clean up
pygame.quit()
