import pygame

pygame.init()

# Set up the game window
screen = pygame.display.set_mode((800, 600))
pygame.display.set_caption("Collision Example")
clock = pygame.time.Clock()

# Load player image
player_image = pygame.image.load("images/p1.png").convert_alpha()
player_rect = player_image.get_rect()
player_rect.topleft = (100, 300)

# Create a basic enemy surface (you could also use an image)
enemy_image = pygame.Surface((80, 80), pygame.SRCALPHA)
enemy_image.fill((255, 0, 0))  # Start as red
enemy_rect = enemy_image.get_rect()
enemy_rect.topleft = (500, 300)

# Speed
player_speed = 5

# Game loop
running = True
while running:
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False

    # Player movement (arrow keys)
    keys = pygame.key.get_pressed()
    if keys[pygame.K_LEFT]:
        player_rect.x -= player_speed
    if keys[pygame.K_RIGHT]:
        player_rect.x += player_speed
    if keys[pygame.K_UP]:
        player_rect.y -= player_speed
    if keys[pygame.K_DOWN]:
        player_rect.y += player_speed

    # Collision detection: if the player touches the enemy
    if player_rect.colliderect(enemy_rect):
        enemy_image.fill((0, 255, 0))  # Turn green when hit
    else:
        enemy_image.fill((255, 0, 0))  # Stay red when not hit

    # Drawing
    screen.fill((30, 30, 30))  # Background
    screen.blit(player_image, player_rect)
    screen.blit(enemy_image, enemy_rect)
    pygame.display.flip()
    clock.tick(60)

pygame.quit()
