import pygame

# --- Window and Setup ---
pygame.init()
WIDTH, HEIGHT = 800, 600
screen = pygame.display.set_mode((WIDTH, HEIGHT))
pygame.display.set_caption("Sprite Move/Collide/Animate + Patrol Enemy")
clock = pygame.time.Clock()

# --- Player: 4-frame animation for ONE character ---
image_sprite = [
    pygame.image.load("images/frame01.png").convert_alpha(),
    pygame.image.load("images/frame02.png").convert_alpha(),
    pygame.image.load("images/frame03.png").convert_alpha(),
    pygame.image.load("images/frame04.png").convert_alpha(),
]
player_rect = image_sprite[0].get_rect()
player_rect.topleft = (100, 300)
player_speed = 5

# --- Enemy: red square that will patrol horizontally ---
enemy_image = pygame.Surface((80, 80), pygame.SRCALPHA)
enemy_image.fill((255, 0, 0))
enemy_rect = enemy_image.get_rect()
enemy_rect.topleft = (500, 300)
enemy_speed = 3
enemy_dir = 1  # 1 = moving right, -1 = moving left

# --- Animation timing (ms) ---
frame_index = 0
animation_timer = 0
animation_speed = 150  # ms between frames

running = True
while running:
    # --- Events ---
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False

    # --- Keyboard Input (continuous) ---
    keys = pygame.key.get_pressed()
    if keys[pygame.K_LEFT]:
        player_rect.x -= player_speed
    if keys[pygame.K_RIGHT]:
        player_rect.x += player_speed
    if keys[pygame.K_UP]:
        player_rect.y -= player_speed
    if keys[pygame.K_DOWN]:
        player_rect.y += player_speed

    # --- Collision Detection ---
    if player_rect.colliderect(enemy_rect):
        enemy_image.fill((0, 255, 0))   # green on collision
    else:
        enemy_image.fill((255, 0, 0))   # red otherwise

    # --- Enemy patrol movement + edge bounce ---
    enemy_rect.x += enemy_speed * enemy_dir
    if enemy_rect.left <= 0:
        enemy_rect.left = 0
        enemy_dir = 1
    elif enemy_rect.right >= WIDTH:
        enemy_rect.right = WIDTH
        enemy_dir = -1

    # --- Animation timing + frame cap ---
    frame_time = clock.tick(60)  # limit to ~60 FPS; ms since last tick
    animation_timer += frame_time
    if animation_timer >= animation_speed:
        animation_timer %= animation_speed
        frame_index = (frame_index + 1) % len(image_sprite)

    # --- Drawing and Presentation ---
    screen.fill((30, 30, 30))
    screen.blit(image_sprite[frame_index], player_rect)  # animated player
    screen.blit(enemy_image, enemy_rect)                 # enemy
    pygame.display.flip()

# Clean exit
pygame.quit()
