import pygame

# Initialize Pygame
pygame.init()

# Create the game window
screen = pygame.display.set_mode((640, 400))
pygame.display.set_caption("Interactive Window")

# Set up a clock to control the frame rate
clock = pygame.time.Clock()

# Set up a player rectangle
player_x = 400
player_y = 300
player_speed = 5
player_size = 40

# Game loop control variable
running = True

while running:
    # Handle input events (such as window close and key presses)
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False
        elif event.type == pygame.KEYDOWN:
            if event.key == pygame.K_SPACE:
                print("Space bar pressed")
            if event.key == pygame.K_ESCAPE:
                print("Escape key pressed – You could pause or open a menu here")

    # Get keys currently held down
    keys = pygame.key.get_pressed()
    if keys[pygame.K_LEFT]:
        player_x -= player_speed
    if keys[pygame.K_RIGHT]:
        player_x += player_speed
    if keys[pygame.K_UP]:
        player_y -= player_speed
    if keys[pygame.K_DOWN]:
        player_y += player_speed

    # Fill screen with a background color
    screen.fill((30, 30, 30))

    # Draw the player as a red square
    pygame.draw.rect(screen, (200, 50, 50), (player_x, player_y, player_size, player_size))

    # Update the display
    pygame.display.flip()

    # Limit to 60 frames per second
    clock.tick(60)

# Quit Pygame properly
pygame.quit()
