import pygame

# 1) Initialize Pygame
pygame.init()

# 2) Create display window
screen_width = 800
screen_height = 600
screen = pygame.display.set_mode((screen_width, screen_height))

# 3) Set window title
pygame.display.set_caption("Blitting Example")

# 4) Load images
# Ensure these files exist relative to your working directory:
#   images/bg.png
#   images/sprite.png
background = pygame.image.load("images/bg.jpg")
sprite = pygame.image.load("images/ufo.png")

# 5) Create a Rect for the sprite and position it
sprite_rect = sprite.get_rect()
sprite_rect.topleft = (100, 400)   # position somewhere on screen

# 6) Prepare text (default font, size 36, white)
font = pygame.font.Font(None, 36)
text_surface = font.render("Hello, Pygame!", True, (255, 255, 255))

# 7) Game loop
running = True
while running:
    # Process events and handle QUIT
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False

    # --- Draw frame ---
    # Background image at top-left
    screen.blit(background, (0, 0))

    # Sprite at its rect position
    screen.blit(sprite, sprite_rect)

    # Draw shapes directly to the screen surface
    pygame.draw.rect(screen, (255, 0, 0), (50, 150, 150, 60))          # red rectangle
    pygame.draw.circle(screen, (0, 255, 0), (400, 150), 40)           # green circle
    pygame.draw.line(screen, (0, 0, 255), (400, 400), (300, 300), 5)  # blue line
    pygame.draw.ellipse(screen, (255, 255, 0), (500, 350, 150, 80))   # yellow ellipse

    # Blit text
    screen.blit(text_surface, (50, 20))

    # Present frame
    pygame.display.flip()

# 8) Clean shutdown
pygame.quit()
