import random

# Define the Player class
class Player:
    def __init__(self, name):
        self.name = name
        self.score = 0
        self.lives = 3

    def add_score(self, points):
        self.score += points

    def take_damage(self):
        self.lives -= 1

    def is_game_over(self):
        return self.lives == 0

    def show_status(self):
        print(f"{self.name} | Score: {self.score} | Lives: {self.lives}")

# Create a player object
player1 = Player("Hero")

# Simulate 3 turns
for turn in range(1, 4):
    print(f"\n--- Turn {turn} ---")

    # Add a random score (100, 200, or 300)
    points = random.choice([100, 200, 300])
    player1.add_score(points)

    # Player takes damage
    player1.take_damage()

    # Show current status
    player1.show_status()

    # Check for game over
    if player1.is_game_over():
        print("Game Over")
        break

# Save final score to a file
with open("final_score.txt", "w") as file:
    file.write(f"Final Score for {player1.name}: {player1.score}\n")

print("\nFinal score saved to final_score.txt.")
